/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.plugin.optimization;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.category.OptimizationCategory;
import org.spongepowered.common.config.type.GlobalConfig;

public class SpongeForgeOptimizationPlugin
implements IMixinConfigPlugin {
    private static final Map<String, Function<OptimizationCategory, Boolean>> mixinEnabledMappings = ImmutableMap.builder().put((Object)"org.spongepowered.mod.mixin.optimization.threadchecks.MinecraftMixin_ForgeThreadChecks", OptimizationCategory::useFastThreadChecks).put((Object)"org.spongepowered.mod.mixin.optimization.threadchecks.MinecraftServerMixin_ForgeThreadChecks", OptimizationCategory::useFastThreadChecks).put((Object)"org.spongepowered.mod.mixin.optimization.threadchecks.SpongeImplHooksMixin_ForgeThreadChecks", OptimizationCategory::useFastThreadChecks).put((Object)"org.spongepowered.mod.mixin.optimization.logspam.ForgeHooksMixin_DisableLogSpamFromAdvancements", OptimizationCategory::disableFailingAdvancementDeserialization).build();

    @Override
    public void onLoad(String mixinPackage) {
    }

    @Override
    public String getRefMapperConfig() {
        return null;
    }

    @Override
    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        GlobalConfig globalConfig = SpongeImpl.getGlobalConfigAdapter().getConfig();
        if (globalConfig.getModules().useOptimizations()) {
            Function<OptimizationCategory, Boolean> optimizationCategoryBooleanFunction = mixinEnabledMappings.get(mixinClassName);
            if (optimizationCategoryBooleanFunction == null) {
                new PrettyPrinter(50).add("Could not find function for optimization patch").centre().hr().add("Missing function for class: " + mixinClassName).trace();
                return false;
            }
            return optimizationCategoryBooleanFunction.apply(globalConfig.getOptimizations());
        }
        return false;
    }

    @Override
    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    @Override
    public List<String> getMixins() {
        return null;
    }

    @Override
    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    @Override
    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

