/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.fml.common;

import java.io.File;
import java.math.BigInteger;
import java.util.List;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionRange;
import net.minecraftforge.fml.relauncher.libraries.LibraryManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.util.PathTokens;
import org.spongepowered.plugin.meta.version.ComparableVersion;

@Mixin(value={Loader.class}, remap=false)
public abstract class LoaderMixin_Forge {
    @Shadow
    private static File minecraftDir;
    private ModContainer forgeImpl$mod;

    @Redirect(method={"identifyMods"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/fml/relauncher/libraries/LibraryManager;gatherLegacyCanidates(Ljava/io/File;)Ljava/util/List;", remap=false), remap=false)
    private List<File> discoverAndAddPluginsBeforeIterator(File mcDir) {
        List files = LibraryManager.gatherLegacyCanidates((File)minecraftDir);
        File modsFolder = new File(minecraftDir, "mods");
        File pluginsDir = new File(PathTokens.replace(SpongeImpl.getGlobalConfigAdapter().getConfig().getGeneral().pluginsDir()));
        if (pluginsDir.isDirectory() && !pluginsDir.equals(modsFolder)) {
            FMLLog.log.info("Searching %s for plugins", (Object)pluginsDir.getAbsolutePath());
            File[] pluginFiles = pluginsDir.listFiles((dir, name) -> name.endsWith(".jar") || name.endsWith(".zip"));
            if (pluginFiles != null) {
                for (File pluginFile : pluginFiles) {
                    if (files.contains(pluginFile)) continue;
                    FMLLog.log.debug("  Adding {} to the plugin list", (Object)pluginFile.getName());
                    files.add(pluginFile);
                }
            }
        }
        return files;
    }

    @Redirect(method={"sortModList"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/fml/common/ModContainer;getDependencies()Ljava/util/List;", remap=false))
    private List<ArtifactVersion> forgeImpl$AssignModBeforeGettingDependencies(ModContainer mod) {
        this.forgeImpl$mod = mod;
        return mod.getDependencies();
    }

    @Redirect(method={"sortModList"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/fml/common/versioning/ArtifactVersion;containsVersion(Lnet/minecraftforge/fml/common/versioning/ArtifactVersion;)Z", remap=false))
    private boolean forgeImpl$sortVersion(ArtifactVersion expected, ArtifactVersion installed) {
        BigInteger majorInstalled;
        BigInteger majorExpected;
        VersionRange range;
        String installedVersion = installed.getVersionString();
        if (!("unknown".equals(installedVersion) || !(expected instanceof DefaultArtifactVersion) || (range = ((DefaultArtifactVersion)expected).getRange()) == null || range.getRecommendedVersion() == null || installedVersion.equals(range.getRecommendedVersion().getVersionString()) || (majorExpected = new ComparableVersion(range.getRecommendedVersion().getVersionString()).getFirstInteger()) == null || (majorInstalled = new ComparableVersion(installedVersion).getFirstInteger()) == null || majorExpected.equals(majorInstalled) && installed.compareTo((Object)range.getRecommendedVersion()) >= 0)) {
            SpongeImpl.getLogger().warn("The mod {} was designed for {} {} but version {} is in use. It may not work properly.", (Object)this.forgeImpl$mod.getModId(), (Object)expected.getLabel(), (Object)expected.getRangeString(), (Object)installed.getVersionString());
        }
        return expected.containsVersion(installed);
    }
}

