/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.event;

import com.flowpowered.math.vector.Vector3d;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.action.FishingEvent;
import org.spongepowered.api.event.advancement.AdvancementEvent;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.block.NotifyNeighborBlockEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnType;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.AffectEntityEvent;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.event.item.inventory.InteractItemEvent;
import org.spongepowered.api.event.item.inventory.UseItemStackEvent;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.event.world.LoadWorldEvent;
import org.spongepowered.api.event.world.SaveWorldEvent;
import org.spongepowered.api.event.world.UnloadWorldEvent;
import org.spongepowered.api.event.world.chunk.LoadChunkEvent;
import org.spongepowered.api.event.world.chunk.UnloadChunkEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.world.chunk.ChunkProviderServerBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.UnwindingPhaseContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.entity.EntityLivingBaseAccessor;
import org.spongepowered.common.mixin.core.world.ExplosionAccessor;
import org.spongepowered.common.registry.provider.DirectionFacingProvider;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.WorldManager;
import org.spongepowered.mod.bridge.event.EventBusBridge_Forge;
import org.spongepowered.mod.bridge.world.DerivedWorldInfoBridge_Forge;
import org.spongepowered.mod.bridge.world.WorldBridge_Forge;
import org.spongepowered.mod.event.SpongeToForgeEventData;

public class SpongeToForgeEventFactory {
    static final EventBusBridge_Forge forgeEventBus = (EventBusBridge_Forge)MinecraftForge.EVENT_BUS;

    static Class<? extends net.minecraftforge.fml.common.eventhandler.Event> getForgeEventClass(Event spongeEvent) {
        if (spongeEvent instanceof MessageChannelEvent.Chat) {
            return ServerChatEvent.class;
        }
        if (spongeEvent instanceof ChangeInventoryEvent.Pickup.Pre) {
            if (spongeEvent.getCause().root() instanceof Player) {
                return EntityItemPickupEvent.class;
            }
        } else {
            if (spongeEvent instanceof DestructEntityEvent.Death) {
                return LivingDeathEvent.class;
            }
            if (spongeEvent instanceof InteractBlockEvent) {
                if (spongeEvent instanceof InteractBlockEvent.Primary) {
                    return PlayerInteractEvent.LeftClickBlock.class;
                }
                if (spongeEvent instanceof InteractBlockEvent.Secondary) {
                    return PlayerInteractEvent.RightClickBlock.class;
                }
            } else {
                if (spongeEvent instanceof InteractEntityEvent.Secondary) {
                    InteractEntityEvent event = (InteractEntityEvent)spongeEvent;
                    if (event.getInteractionPoint().isPresent()) {
                        return PlayerInteractEvent.EntityInteractSpecific.class;
                    }
                    return PlayerInteractEvent.EntityInteract.class;
                }
                if (spongeEvent instanceof InteractItemEvent.Secondary) {
                    return PlayerInteractEvent.RightClickItem.class;
                }
                if (spongeEvent instanceof NotifyNeighborBlockEvent) {
                    return BlockEvent.NeighborNotifyEvent.class;
                }
                if (spongeEvent instanceof ChangeBlockEvent.Place) {
                    if (((ChangeBlockEvent)spongeEvent).getTransactions().size() > 1) {
                        return BlockEvent.MultiPlaceEvent.class;
                    }
                    return BlockEvent.PlaceEvent.class;
                }
                if (spongeEvent instanceof ExplosionEvent.Pre) {
                    return ExplosionEvent.Start.class;
                }
                if (spongeEvent instanceof ExplosionEvent.Detonate) {
                    return ExplosionEvent.Detonate.class;
                }
                if (spongeEvent instanceof DropItemEvent) {
                    Object source = spongeEvent.getSource();
                    if (spongeEvent instanceof DropItemEvent.Destruct && (source instanceof Living || source instanceof org.spongepowered.api.event.cause.entity.damage.source.DamageSource)) {
                        return LivingDropsEvent.class;
                    }
                    if ((spongeEvent instanceof DropItemEvent.Dispense || spongeEvent instanceof DropItemEvent.Custom) && source instanceof Player) {
                        if (((EventBusBridge_Forge)MinecraftForge.EVENT_BUS).forgeBridge$getEventListenerClassList().contains(ItemTossEvent.class)) {
                            return ItemTossEvent.class;
                        }
                        if (((EventBusBridge_Forge)MinecraftForge.EVENT_BUS).forgeBridge$getEventListenerClassList().contains(EntityJoinWorldEvent.class)) {
                            return EntityJoinWorldEvent.class;
                        }
                        return null;
                    }
                } else if (spongeEvent instanceof ClientConnectionEvent) {
                    if (spongeEvent instanceof ClientConnectionEvent.Join) {
                        return PlayerEvent.PlayerLoggedInEvent.class;
                    }
                    if (spongeEvent instanceof ClientConnectionEvent.Disconnect) {
                        return PlayerEvent.PlayerLoggedOutEvent.class;
                    }
                } else {
                    if (spongeEvent instanceof MoveEntityEvent.Teleport) {
                        return EntityTravelToDimensionEvent.class;
                    }
                    if (spongeEvent instanceof SpawnEntityEvent) {
                        return EntityJoinWorldEvent.class;
                    }
                    if (spongeEvent instanceof LoadWorldEvent) {
                        return WorldEvent.Load.class;
                    }
                    if (spongeEvent instanceof UnloadWorldEvent) {
                        return WorldEvent.Unload.class;
                    }
                    if (spongeEvent instanceof SaveWorldEvent.Post) {
                        return WorldEvent.Save.class;
                    }
                    if (spongeEvent instanceof LoadChunkEvent) {
                        return ChunkEvent.Load.class;
                    }
                    if (spongeEvent instanceof UnloadChunkEvent) {
                        return ChunkEvent.Unload.class;
                    }
                    if (spongeEvent instanceof FishingEvent.Stop) {
                        return ItemFishedEvent.class;
                    }
                    if (spongeEvent instanceof UseItemStackEvent) {
                        if (spongeEvent instanceof UseItemStackEvent.Start) {
                            return LivingEntityUseItemEvent.Start.class;
                        }
                        if (spongeEvent instanceof UseItemStackEvent.Tick) {
                            return LivingEntityUseItemEvent.Tick.class;
                        }
                        if (spongeEvent instanceof UseItemStackEvent.Stop) {
                            return LivingEntityUseItemEvent.Stop.class;
                        }
                        if (spongeEvent instanceof UseItemStackEvent.Replace) {
                            return LivingEntityUseItemEvent.Finish.class;
                        }
                    } else if (spongeEvent instanceof AdvancementEvent.Grant) {
                        return AdvancementEvent.class;
                    }
                }
            }
        }
        return null;
    }

    static boolean createAndPostForgeEvent(SpongeToForgeEventData spongeEventData) {
        Class<? extends net.minecraftforge.fml.common.eventhandler.Event> clazz = spongeEventData.getForgeClass();
        Event spongeEvent = spongeEventData.getSpongeEvent();
        if (spongeEvent instanceof MessageChannelEvent.Chat) {
            return SpongeToForgeEventFactory.createAndPostServerChatEvent(spongeEventData);
        }
        if (spongeEvent instanceof ChangeInventoryEvent.Pickup.Pre) {
            return SpongeToForgeEventFactory.createAndPostEntityItemPickupEvent(spongeEventData);
        }
        if (spongeEvent instanceof InteractEntityEvent.Secondary) {
            return SpongeToForgeEventFactory.createAndPostEntityInteractEvent(spongeEventData);
        }
        if (spongeEvent instanceof NotifyNeighborBlockEvent) {
            return SpongeToForgeEventFactory.createAndPostNeighborNotifyEvent(spongeEventData);
        }
        if (spongeEvent instanceof ChangeBlockEvent.Place) {
            return SpongeToForgeEventFactory.createAndPostBlockPlaceEvent(spongeEventData);
        }
        if (spongeEvent instanceof ChangeBlockEvent.Pre) {
            return SpongeToForgeEventFactory.createAndPostBlockBreakEvent(spongeEventData);
        }
        if (PlayerInteractEvent.class.isAssignableFrom(clazz)) {
            if (spongeEvent instanceof InteractBlockEvent) {
                return SpongeToForgeEventFactory.createAndPostPlayerInteractBlockEvent(spongeEventData);
            }
            if (spongeEvent instanceof InteractItemEvent.Secondary) {
                return SpongeToForgeEventFactory.createAndPostPlayerInteractItemEvent(spongeEventData);
            }
        } else if (LivingDropsEvent.class.isAssignableFrom(clazz)) {
            if (spongeEvent instanceof DropItemEvent.Destruct) {
                Object root = spongeEventData.getSpongeEvent().getSource();
                if (root instanceof Player) {
                    return SpongeToForgeEventFactory.createAndPostItemTossEvent(spongeEventData);
                }
                return SpongeToForgeEventFactory.createAndPostLivingDropsEventEvent(spongeEventData);
            }
        } else if (ItemTossEvent.class.isAssignableFrom(clazz)) {
            Object root;
            if (spongeEvent instanceof DropItemEvent.Dispense && (root = spongeEvent.getSource()) instanceof Player) {
                return SpongeToForgeEventFactory.createAndPostItemTossEvent(spongeEventData);
            }
        } else {
            if (spongeEvent instanceof ClientConnectionEvent.Join) {
                return SpongeToForgeEventFactory.createAndPostPlayerLoggedInEvent(spongeEventData);
            }
            if (spongeEvent instanceof ClientConnectionEvent.Disconnect) {
                return SpongeToForgeEventFactory.createAndPostPlayerLoggedOutEvent(spongeEventData);
            }
            if (EntityJoinWorldEvent.class.isAssignableFrom(clazz)) {
                return SpongeToForgeEventFactory.createAndPostEntityJoinWorldEvent(spongeEventData);
            }
            if (spongeEvent instanceof UnloadWorldEvent) {
                return SpongeToForgeEventFactory.createAndPostWorldUnloadEvent(spongeEventData);
            }
            if (spongeEvent instanceof LoadWorldEvent) {
                return SpongeToForgeEventFactory.createAndPostWorldLoadEvent(spongeEventData);
            }
            if (spongeEvent instanceof SaveWorldEvent) {
                return SpongeToForgeEventFactory.createAndPostWorldSaveEvent(spongeEventData);
            }
            if (spongeEvent instanceof LoadChunkEvent) {
                return SpongeToForgeEventFactory.createAndPostChunkLoadEvent(spongeEventData);
            }
            if (spongeEvent instanceof UnloadChunkEvent) {
                return SpongeToForgeEventFactory.createAndPostChunkUnloadEvent(spongeEventData);
            }
            if (spongeEvent instanceof ExplosionEvent.Pre) {
                return SpongeToForgeEventFactory.createAndPostExplosionEventPre(spongeEventData);
            }
            if (spongeEvent instanceof ExplosionEvent.Detonate) {
                return SpongeToForgeEventFactory.createAndPostExplosionEventDetonate(spongeEventData);
            }
            if (spongeEvent instanceof FishingEvent.Stop) {
                return SpongeToForgeEventFactory.createAndPostItemFishedEvent(spongeEventData);
            }
            if (spongeEvent instanceof UseItemStackEvent) {
                return SpongeToForgeEventFactory.createAndPostLivingUseItemEvent(spongeEventData);
            }
            if (spongeEvent instanceof AdvancementEvent.Grant) {
                return SpongeToForgeEventFactory.createAndPostAdvancementGrantEvent(spongeEventData);
            }
        }
        return false;
    }

    private static boolean createAndPostServerChatEvent(SpongeToForgeEventData eventData) {
        MessageChannelEvent.Chat spongeEvent = (MessageChannelEvent.Chat)eventData.getSpongeEvent();
        ServerChatEvent forgeEvent = (ServerChatEvent)eventData.getForgeEvent();
        ITextComponent originalComponent = null;
        if (forgeEvent == null && spongeEvent.getSource() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)spongeEvent.getSource();
            originalComponent = SpongeTexts.toComponent(spongeEvent.getMessage());
            forgeEvent = new ServerChatEvent(player, spongeEvent.getRawMessage().toPlain(), originalComponent.func_150259_f());
            eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
        } else if (forgeEvent != null) {
            originalComponent = SpongeTexts.toComponent(spongeEvent.getMessage());
        }
        if (forgeEvent != null) {
            forgeEvent.setCanceled(spongeEvent.isCancelled());
            forgeEventBus.forgeBridge$post(eventData);
            if (!originalComponent.equals(forgeEvent.getComponent())) {
                spongeEvent.setMessage(SpongeTexts.toText(forgeEvent.getComponent()));
            }
        }
        return true;
    }

    private static boolean createAndPostLivingUseItemEvent(SpongeToForgeEventData eventData) {
        UseItemStackEvent spongeEvent = (UseItemStackEvent)eventData.getSpongeEvent();
        LivingEntityUseItemEvent forgeEvent = (LivingEntityUseItemEvent)eventData.getForgeEvent();
        if (forgeEvent == null) {
            EntityLivingBase entity = spongeEvent.getCause().first(EntityLivingBase.class).orElse(null);
            if (entity == null) {
                return false;
            }
            ItemStack stack = ItemStackUtil.toNative(spongeEvent.getItemStackInUse().createStack());
            if (spongeEvent instanceof UseItemStackEvent.Start) {
                forgeEvent = new LivingEntityUseItemEvent.Start(entity, stack, spongeEvent.getRemainingDuration());
                forgeEvent.setCanceled(((UseItemStackEvent.Start)spongeEvent).isCancelled());
            } else if (spongeEvent instanceof UseItemStackEvent.Tick) {
                forgeEvent = new LivingEntityUseItemEvent.Tick(entity, stack, spongeEvent.getRemainingDuration());
                forgeEvent.setCanceled(((UseItemStackEvent.Tick)spongeEvent).isCancelled());
            } else if (spongeEvent instanceof UseItemStackEvent.Stop) {
                forgeEvent = new LivingEntityUseItemEvent.Stop(entity, stack, spongeEvent.getRemainingDuration());
                forgeEvent.setCanceled(((UseItemStackEvent.Stop)spongeEvent).isCancelled());
            } else if (spongeEvent instanceof UseItemStackEvent.Replace && (forgeEvent = new LivingEntityUseItemEvent.Finish(entity, stack, spongeEvent.getRemainingDuration(), ItemStackUtil.toNative(((UseItemStackEvent.Replace)spongeEvent).getItemStackResult().getFinal().createStack()))).isCancelable()) {
                forgeEvent.setCanceled(((UseItemStackEvent.Replace)spongeEvent).isCancelled());
            }
            if (forgeEvent == null) {
                return false;
            }
            eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
        } else {
            forgeEvent.setDuration(spongeEvent.getRemainingDuration());
        }
        forgeEventBus.forgeBridge$post(eventData);
        spongeEvent.setRemainingDuration(forgeEvent.getDuration());
        if (forgeEvent.isCanceled()) {
            if (forgeEvent instanceof LivingEntityUseItemEvent.Tick) {
                spongeEvent.setRemainingDuration(-1);
            } else {
                ((Cancellable)((Object)spongeEvent)).setCancelled(true);
            }
        }
        if (forgeEvent instanceof LivingEntityUseItemEvent.Finish) {
            ((UseItemStackEvent.Replace)spongeEvent).getItemStackResult().setCustom(ItemStackUtil.snapshotOf(((LivingEntityUseItemEvent.Finish)forgeEvent).getResultStack()));
        }
        return true;
    }

    private static boolean createAndPostAdvancementGrantEvent(SpongeToForgeEventData eventData) {
        AdvancementEvent.Grant spongeEvent = (AdvancementEvent.Grant)eventData.getSpongeEvent();
        AdvancementEvent forgeEvent = (AdvancementEvent)eventData.getForgeEvent();
        if (forgeEvent == null) {
            forgeEvent = new AdvancementEvent((EntityPlayer)spongeEvent.getTargetEntity(), (Advancement)spongeEvent.getAdvancement());
            eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
        }
        forgeEventBus.forgeBridge$post((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent, true);
        return true;
    }

    private static boolean createAndPostItemTossEvent(SpongeToForgeEventData eventData) {
        SpawnEntityEvent spongeEvent = (SpawnEntityEvent)eventData.getSpongeEvent();
        ItemTossEvent forgeEvent = (ItemTossEvent)eventData.getForgeEvent();
        if (forgeEvent == null) {
            Cause cause = spongeEvent.getCause();
            SpawnType spawnType = cause.getContext().get(EventContextKeys.SPAWN_TYPE).orElse(null);
            EntityPlayerMP serverPlayer = (EntityPlayerMP)spongeEvent.getCause().root();
            if (spawnType == null || spawnType != SpawnTypes.DROPPED_ITEM || spongeEvent.getEntities().isEmpty()) {
                return false;
            }
            spongeEvent.filterEntities(e -> e instanceof EntityItem && !forgeEventBus.forgeBridge$post((net.minecraftforge.fml.common.eventhandler.Event)new ItemTossEvent((EntityItem)e, (EntityPlayer)serverPlayer), true));
            SpongeToForgeEventFactory.createAndPostEntityJoinWorldEvent(eventData);
            SpongeToForgeEventFactory.handleCustomStack(spongeEvent);
            return true;
        }
        if (spongeEvent.isCancelled() || spongeEvent.getEntities().isEmpty()) {
            return false;
        }
        forgeEventBus.forgeBridge$post(eventData);
        return true;
    }

    private static boolean createAndPostPlayerInteractBlockEvent(SpongeToForgeEventData eventData) {
        InteractBlockEvent spongeEvent = (InteractBlockEvent)eventData.getSpongeEvent();
        PlayerInteractEvent forgeEvent = (PlayerInteractEvent)eventData.getForgeEvent();
        if (forgeEvent == null) {
            Player player = spongeEvent.getCause().first(Player.class).orElse(null);
            if (player == null || spongeEvent instanceof InteractBlockEvent.Primary && spongeEvent.getTargetBlock() == org.spongepowered.api.block.BlockSnapshot.NONE) {
                return false;
            }
            BlockPos pos = VecHelper.toBlockPos(spongeEvent.getTargetBlock().getPosition());
            EnumFacing face = DirectionFacingProvider.getInstance().get(spongeEvent.getTargetSide()).orElse(null);
            Vec3d hitVec = null;
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)player;
            if (spongeEvent.getInteractionPoint().isPresent()) {
                hitVec = VecHelper.toVec3d(spongeEvent.getInteractionPoint().get());
            }
            if (spongeEvent instanceof InteractBlockEvent.Primary) {
                forgeEvent = new PlayerInteractEvent.LeftClickBlock((EntityPlayer)entityPlayerMP, pos, face, hitVec);
            } else if (spongeEvent instanceof InteractBlockEvent.Secondary) {
                EnumHand hand = spongeEvent instanceof InteractBlockEvent.Secondary.MainHand ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
                forgeEvent = new PlayerInteractEvent.RightClickBlock((EntityPlayer)entityPlayerMP, hand, pos, face, hitVec);
            }
            if (forgeEvent == null) {
                return false;
            }
            eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
        }
        forgeEvent.setCanceled(spongeEvent.isCancelled());
        forgeEventBus.forgeBridge$post(eventData);
        if (forgeEvent instanceof PlayerInteractEvent.RightClickBlock) {
            PlayerInteractEvent.RightClickBlock event = (PlayerInteractEvent.RightClickBlock)forgeEvent;
            if (event.getUseItem() != Event.Result.DEFAULT) {
                ((InteractBlockEvent.Secondary)spongeEvent).setUseItemResult(SpongeToForgeEventFactory.getTristateFromResult(event.getUseItem()));
            }
            if (event.getUseBlock() != Event.Result.DEFAULT) {
                ((InteractBlockEvent.Secondary)spongeEvent).setUseBlockResult(SpongeToForgeEventFactory.getTristateFromResult(event.getUseBlock()));
            }
        }
        return true;
    }

    private static boolean createAndPostPlayerInteractItemEvent(SpongeToForgeEventData eventData) {
        InteractItemEvent.Secondary spongeEvent = (InteractItemEvent.Secondary)eventData.getSpongeEvent();
        PlayerInteractEvent.RightClickItem forgeEvent = (PlayerInteractEvent.RightClickItem)eventData.getForgeEvent();
        if (forgeEvent == null) {
            Player player = spongeEvent.getCause().first(Player.class).orElse(null);
            if (player == null) {
                return false;
            }
            EnumHand hand = spongeEvent instanceof InteractItemEvent.Secondary.MainHand ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
            forgeEvent = new PlayerInteractEvent.RightClickItem((EntityPlayer)((EntityPlayerMP)player), hand);
            eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
        }
        forgeEvent.setCanceled(spongeEvent.isCancelled());
        forgeEventBus.forgeBridge$post(eventData);
        return true;
    }

    private static boolean createAndPostEntityItemPickupEvent(SpongeToForgeEventData eventData) {
        ChangeInventoryEvent.Pickup.Pre spongeEvent = (ChangeInventoryEvent.Pickup.Pre)eventData.getSpongeEvent();
        EntityItemPickupEvent forgeEvent = (EntityItemPickupEvent)eventData.getForgeEvent();
        if (forgeEvent == null) {
            if (spongeEvent.getTargetEntity() instanceof EntityItem) {
                EntityItem entityItem = (EntityItem)spongeEvent.getTargetEntity();
                Player player = spongeEvent.getCause().first(Player.class).orElse(null);
                if (player != null) {
                    forgeEvent = new EntityItemPickupEvent((EntityPlayer)player, entityItem);
                    eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
                }
            }
            if (forgeEvent == null) {
                return false;
            }
            eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
        }
        forgeEvent.setCanceled(spongeEvent.isCancelled());
        forgeEventBus.forgeBridge$post(eventData);
        return true;
    }

    private static boolean createAndPostLivingDropsEventEvent(SpongeToForgeEventData eventData) {
        AffectEntityEvent spongeEvent = (AffectEntityEvent)eventData.getSpongeEvent();
        LivingDropsEvent forgeEvent = (LivingDropsEvent)eventData.getForgeEvent();
        Cause cause = spongeEvent.getCause();
        EntityLivingBase living = cause.first(EntityLivingBase.class).orElse(null);
        if (living != null && spongeEvent instanceof DropItemEvent.Destruct) {
            DropItemEvent.Destruct destruct = (DropItemEvent.Destruct)spongeEvent;
            DamageSource damageSource = cause.first(org.spongepowered.api.event.cause.entity.damage.source.DamageSource.class).orElse(null);
            if (damageSource != null) {
                List items = destruct.getEntities().stream().filter(e -> e instanceof EntityItem).map(e -> (EntityItem)e).collect(Collectors.toList());
                if (forgeEvent == null) {
                    if (living instanceof EntityPlayerMP) {
                        EntityPlayerMP serverPlayer = (EntityPlayerMP)living;
                        forgeEvent = new PlayerDropsEvent((EntityPlayer)serverPlayer, damageSource, new ArrayList(items), ((EntityLivingBaseAccessor)serverPlayer).accessor$getRecentlyHitValue() > 0);
                    } else {
                        forgeEvent = new LivingDropsEvent(living, damageSource, new ArrayList(items), ForgeHooks.getLootingLevel((net.minecraft.entity.Entity)living, (net.minecraft.entity.Entity)damageSource.func_76346_g(), (DamageSource)damageSource), ((EntityLivingBaseAccessor)living).accessor$getRecentlyHitValue() > 0);
                    }
                    eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
                } else if (spongeEvent.getEntities().size() != forgeEvent.getDrops().size()) {
                    forgeEvent.getDrops().clear();
                    for (Entity entity2 : spongeEvent.getEntities()) {
                        if (!(entity2 instanceof EntityItem)) continue;
                        forgeEvent.getDrops().add((EntityItem)entity2);
                    }
                }
                forgeEventBus.forgeBridge$post(eventData);
                if (forgeEvent.isCanceled()) {
                    spongeEvent.setCancelled(true);
                    return true;
                }
                spongeEvent.getEntities().removeAll(items);
                spongeEvent.getEntities().addAll(forgeEvent.getDrops().stream().map(entity -> (Entity)entity).collect(Collectors.toList()));
            }
        }
        return SpongeToForgeEventFactory.createAndPostEntityJoinWorldEvent(eventData);
    }

    private static boolean createAndPostEntityJoinWorldEvent(SpongeToForgeEventData eventData) {
        SpawnEntityEvent spongeEvent = (SpawnEntityEvent)eventData.getSpongeEvent();
        ListIterator<Entity> iterator = spongeEvent.getEntities().listIterator();
        if (spongeEvent.getEntities().isEmpty()) {
            return eventData.getForgeEvent() != null;
        }
        boolean canCancelEvent = true;
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            EntityJoinWorldEvent forgeEvent = new EntityJoinWorldEvent((net.minecraft.entity.Entity)entity, (net.minecraft.world.World)entity.getLocation().getExtent());
            eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
            ((EventBusBridge_Forge)MinecraftForge.EVENT_BUS).forgeBridge$post((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent, true);
            net.minecraft.entity.Entity mcEntity = (net.minecraft.entity.Entity)entity;
            if (mcEntity.field_70128_L) {
                canCancelEvent = false;
            }
            if (!forgeEvent.isCanceled()) continue;
            iterator.remove();
        }
        if (spongeEvent.getEntities().isEmpty() && canCancelEvent) {
            spongeEvent.setCancelled(true);
        }
        return true;
    }

    static void handlePrefireLogic(Event event) {
        if (event instanceof SpawnEntityEvent) {
            SpongeToForgeEventFactory.handleCustomStack((SpawnEntityEvent)event);
        }
    }

    private static void handleCustomStack(SpawnEntityEvent event) {
        ListIterator<Entity> it = event.getEntities().listIterator();
        while (it.hasNext()) {
            net.minecraft.entity.Entity entity = (net.minecraft.entity.Entity)it.next();
            if (!(entity instanceof EntityItem)) continue;
            SpongeToForgeEventFactory.handleCustomEntityFromIterator(it, entity);
        }
    }

    private static void handleCustomEntityFromIterator(ListIterator<Entity> it, net.minecraft.entity.Entity entity) {
        net.minecraft.entity.Entity newEntity;
        ItemStack stack = entity instanceof EntityItem ? ((EntityItem)entity).func_92059_d() : ItemStack.field_190927_a;
        Item item = stack.func_77973_b();
        if (item.hasCustomEntity(stack) && (newEntity = item.createEntity(entity.func_130014_f_(), entity, stack)) != null) {
            entity.func_70106_y();
            EntityJoinWorldEvent cancelledEvent = new EntityJoinWorldEvent(entity, entity.func_130014_f_());
            cancelledEvent.setCanceled(true);
            forgeEventBus.forgeBridge$post((net.minecraftforge.fml.common.eventhandler.Event)cancelledEvent, true);
            if (!cancelledEvent.isCanceled()) {
                SpongeImpl.getLogger().error("A mod has un-cancelled the EntityJoinWorld event for the original EntityItem (from before Item#createEntity is called). This is almost certainly a terrible idea!");
            }
            it.set((Entity)newEntity);
        }
    }

    private static boolean createAndPostNeighborNotifyEvent(SpongeToForgeEventData eventData) {
        NotifyNeighborBlockEvent spongeEvent = (NotifyNeighborBlockEvent)eventData.getSpongeEvent();
        BlockEvent.NeighborNotifyEvent forgeEvent = (BlockEvent.NeighborNotifyEvent)eventData.getForgeEvent();
        if (forgeEvent == null) {
            IBlockState state;
            Location<World> sourceLocation;
            LocatableBlock locatableBlock = spongeEvent.getCause().first(LocatableBlock.class).orElse(null);
            TileEntity tileEntitySource = spongeEvent.getCause().first(TileEntity.class).orElse(null);
            if (locatableBlock != null) {
                sourceLocation = locatableBlock.getLocation();
                state = (IBlockState)locatableBlock.getBlockState();
            } else if (tileEntitySource != null) {
                sourceLocation = tileEntitySource.getLocation();
                state = (IBlockState)sourceLocation.getBlock();
            } else {
                return false;
            }
            EnumSet<EnumFacing> facings = EnumSet.noneOf(EnumFacing.class);
            for (Map.Entry<Direction, BlockState> mapEntry : spongeEvent.getNeighbors().entrySet()) {
                if (mapEntry.getKey() == Direction.NONE) continue;
                facings.add(DirectionFacingProvider.getInstance().get(mapEntry.getKey()).get());
            }
            if (facings.isEmpty()) {
                return false;
            }
            BlockPos pos = VecHelper.toBlockPos(sourceLocation);
            net.minecraft.world.World world = (net.minecraft.world.World)sourceLocation.getExtent();
            forgeEvent = new BlockEvent.NeighborNotifyEvent(world, pos, state, facings, false);
            eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
        } else if (forgeEvent.getNotifiedSides().size() != spongeEvent.getNeighbors().size()) {
            forgeEvent.getNotifiedSides().clear();
            for (Map.Entry<Direction, BlockState> mapEntry : spongeEvent.getNeighbors().entrySet()) {
                forgeEvent.getNotifiedSides().add(DirectionFacingProvider.getInstance().get(mapEntry.getKey()).get());
            }
        }
        forgeEventBus.forgeBridge$post(eventData);
        return true;
    }

    private static boolean createAndPostBlockBreakEvent(SpongeToForgeEventData eventData) {
        ChangeBlockEvent.Pre spongeEvent = (ChangeBlockEvent.Pre)eventData.getSpongeEvent();
        BlockEvent.BreakEvent forgeEvent = (BlockEvent.BreakEvent)eventData.getForgeEvent();
        if (!(spongeEvent.getCause().root() instanceof Player) || spongeEvent.getLocations().size() != 1) {
            return false;
        }
        if (forgeEvent == null) {
            EntityPlayer player = (EntityPlayer)spongeEvent.getCause().root();
            net.minecraft.world.World world = player.field_70170_p;
            Location<World> location = spongeEvent.getLocations().get(0);
            BlockPos pos = VecHelper.toBlockPos(location.getBlockPosition());
            IBlockState state = (IBlockState)location.getBlock();
            forgeEvent = new BlockEvent.BreakEvent(world, pos, state, player);
        }
        forgeEventBus.forgeBridge$post(eventData);
        return true;
    }

    private static boolean createAndPostBlockPlaceEvent(SpongeToForgeEventData eventData) {
        ChangeBlockEvent.Place spongeEvent = (ChangeBlockEvent.Place)eventData.getSpongeEvent();
        BlockEvent.PlaceEvent forgeEvent = (BlockEvent.PlaceEvent)eventData.getForgeEvent();
        if (!(spongeEvent.getCause().root() instanceof Player)) {
            return false;
        }
        if (forgeEvent == null) {
            Object contextPacket;
            PhaseContext<?> currentContext;
            EntityPlayer player = (EntityPlayer)spongeEvent.getCause().root();
            net.minecraft.world.World world = player.field_70170_p;
            PhaseTracker phaseTracker = PhaseTracker.getInstance();
            PhaseContext<Object> target = currentContext = phaseTracker.getCurrentContext();
            if (currentContext instanceof UnwindingPhaseContext) {
                target = ((UnwindingPhaseContext)currentContext).getUnwindingContext();
            }
            PacketContext context = target instanceof PacketContext ? (PacketContext)target : null;
            Object v0 = contextPacket = context != null ? context.getPacket() : null;
            if (contextPacket == null) {
                return false;
            }
            if (spongeEvent.getTransactions().size() == 1) {
                BlockPos pos = VecHelper.toBlockPos(spongeEvent.getTransactions().get(0).getOriginal().getPosition());
                IBlockState state = (IBlockState)spongeEvent.getTransactions().get(0).getOriginal().getState();
                BlockSnapshot blockSnapshot = new BlockSnapshot(world, pos, state);
                IBlockState placedAgainst = Blocks.field_150350_a.func_176223_P();
                EnumHand hand = EnumHand.MAIN_HAND;
                if (contextPacket instanceof CPacketPlayerTryUseItemOnBlock) {
                    CPacketPlayerTryUseItemOnBlock packet = contextPacket;
                    EnumFacing facing = packet.func_187024_b();
                    placedAgainst = blockSnapshot.getWorld().func_180495_p(blockSnapshot.getPos().func_177972_a(facing.func_176734_d()));
                    hand = packet.func_187022_c();
                }
                forgeEvent = new BlockEvent.PlaceEvent(blockSnapshot, placedAgainst, player, hand);
                eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
            } else {
                Iterator<Transaction<org.spongepowered.api.block.BlockSnapshot>> iterator = spongeEvent.getTransactions().iterator();
                ArrayList<BlockSnapshot> blockSnapshots = new ArrayList<BlockSnapshot>();
                while (iterator.hasNext()) {
                    Transaction<org.spongepowered.api.block.BlockSnapshot> transaction = iterator.next();
                    Location<World> location = transaction.getOriginal().getLocation().get();
                    IBlockState state = (IBlockState)transaction.getOriginal().getState();
                    BlockPos pos = new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
                    BlockSnapshot blockSnapshot = new BlockSnapshot(world, pos, state);
                    blockSnapshots.add(blockSnapshot);
                }
                IBlockState placedAgainst = Blocks.field_150350_a.func_176223_P();
                EnumHand hand = EnumHand.MAIN_HAND;
                if (contextPacket instanceof CPacketPlayerTryUseItemOnBlock) {
                    CPacketPlayerTryUseItemOnBlock packet = contextPacket;
                    EnumFacing facing = packet.func_187024_b();
                    placedAgainst = ((BlockSnapshot)blockSnapshots.get(0)).getWorld().func_180495_p(((BlockSnapshot)blockSnapshots.get(0)).getPos().func_177972_a(facing.func_176734_d()));
                    hand = packet.func_187022_c();
                }
                forgeEvent = new BlockEvent.MultiPlaceEvent(blockSnapshots, placedAgainst, player, hand);
                eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
            }
        }
        forgeEventBus.forgeBridge$post(eventData);
        return true;
    }

    private static boolean createAndPostExplosionEventPre(SpongeToForgeEventData eventData) {
        ExplosionEvent.Pre spongeEvent = (ExplosionEvent.Pre)eventData.getSpongeEvent();
        ExplosionEvent.Start forgeEvent = (ExplosionEvent.Start)eventData.getForgeEvent();
        if (forgeEvent == null) {
            forgeEvent = new ExplosionEvent.Start((net.minecraft.world.World)spongeEvent.getTargetWorld(), (Explosion)spongeEvent.getExplosion());
            eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
        }
        forgeEvent.setCanceled(spongeEvent.isCancelled());
        forgeEventBus.forgeBridge$post(eventData);
        return true;
    }

    private static boolean createAndPostExplosionEventDetonate(SpongeToForgeEventData eventData) {
        ExplosionEvent.Detonate spongeEvent = (ExplosionEvent.Detonate)eventData.getSpongeEvent();
        ExplosionEvent.Detonate forgeEvent = (ExplosionEvent.Detonate)eventData.getForgeEvent();
        Explosion explosion = (Explosion)spongeEvent.getExplosion();
        if (explosion == null) {
            return false;
        }
        if (forgeEvent == null) {
            forgeEvent = new ExplosionEvent.Detonate((net.minecraft.world.World)spongeEvent.getTargetWorld(), explosion, spongeEvent.getEntities());
            explosion.func_180343_e().clear();
            for (Location<World> x : spongeEvent.getAffectedLocations()) {
                explosion.func_180343_e().add(VecHelper.toBlockPos(x.getPosition()));
            }
            eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
        }
        if (!((ExplosionAccessor)forgeEvent.getExplosion()).accessor$getDamagesTerrain()) {
            List affectedBlocks = forgeEvent.getExplosion().func_180343_e();
            affectedBlocks.clear();
        }
        if (spongeEvent.getAffectedLocations().size() != forgeEvent.getAffectedBlocks().size()) {
            forgeEvent.getAffectedBlocks().clear();
            for (Location<World> x : spongeEvent.getAffectedLocations()) {
                forgeEvent.getAffectedBlocks().add(VecHelper.toBlockPos(x.getPosition()));
            }
        }
        forgeEventBus.forgeBridge$post(eventData);
        if (spongeEvent.getAffectedLocations().size() != forgeEvent.getAffectedBlocks().size()) {
            spongeEvent.getAffectedLocations().clear();
            for (BlockPos pos : forgeEvent.getAffectedBlocks()) {
                spongeEvent.getAffectedLocations().add(new Location<World>(spongeEvent.getTargetWorld(), VecHelper.toVector3i(pos)));
            }
        }
        return true;
    }

    private static boolean createAndPostEntityInteractEvent(SpongeToForgeEventData eventData) {
        InteractEntityEvent.Secondary spongeEvent = (InteractEntityEvent.Secondary)eventData.getSpongeEvent();
        Object forgeEvent = (PlayerInteractEvent)eventData.getForgeEvent();
        if (forgeEvent == null) {
            Optional<Player> player = spongeEvent.getCause().first(Player.class);
            if (!player.isPresent()) {
                return false;
            }
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)player.get();
            EnumHand hand = entityPlayerMP.func_184600_cs();
            EntityPlayer entityPlayer = (EntityPlayer)player.get();
            net.minecraft.entity.Entity entity = (net.minecraft.entity.Entity)spongeEvent.getTargetEntity();
            Vector3d hitVec = spongeEvent.getInteractionPoint().orElse(null);
            forgeEvent = hitVec != null ? new PlayerInteractEvent.EntityInteractSpecific(entityPlayer, hand, entity, VecHelper.toVec3d(hitVec)) : new PlayerInteractEvent.EntityInteract(entityPlayer, hand, entity);
            eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
        }
        forgeEvent.setCanceled(spongeEvent.isCancelled());
        forgeEventBus.forgeBridge$post(eventData);
        return true;
    }

    private static boolean createAndPostPlayerLoggedInEvent(SpongeToForgeEventData eventData) {
        ClientConnectionEvent.Join spongeEvent = (ClientConnectionEvent.Join)eventData.getSpongeEvent();
        PlayerEvent.PlayerLoggedInEvent forgeEvent = (PlayerEvent.PlayerLoggedInEvent)eventData.getForgeEvent();
        if (forgeEvent == null) {
            forgeEvent = new PlayerEvent.PlayerLoggedInEvent((EntityPlayer)spongeEvent.getTargetEntity());
            eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
        }
        forgeEventBus.forgeBridge$post(eventData);
        return true;
    }

    private static boolean createAndPostPlayerLoggedOutEvent(SpongeToForgeEventData eventData) {
        ClientConnectionEvent.Disconnect spongeEvent = (ClientConnectionEvent.Disconnect)eventData.getSpongeEvent();
        PlayerEvent.PlayerLoggedOutEvent forgeEvent = (PlayerEvent.PlayerLoggedOutEvent)eventData.getForgeEvent();
        if (forgeEvent == null) {
            forgeEvent = new PlayerEvent.PlayerLoggedOutEvent((EntityPlayer)spongeEvent.getTargetEntity());
            eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
        }
        forgeEventBus.forgeBridge$post(eventData);
        return true;
    }

    private static boolean createAndPostWorldSaveEvent(SpongeToForgeEventData eventData) {
        SaveWorldEvent spongeEvent = (SaveWorldEvent)eventData.getSpongeEvent();
        WorldEvent.Save forgeEvent = (WorldEvent.Save)eventData.getForgeEvent();
        ((WorldBridge_Forge)((Object)spongeEvent.getTargetWorld())).forgeBridge$setRedirectedWorldInfo(WorldManager.getWorldByDimensionId(0).get().func_72912_H());
        if (forgeEvent == null) {
            forgeEvent = new WorldEvent.Save((net.minecraft.world.World)spongeEvent.getTargetWorld());
            eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
        }
        forgeEventBus.forgeBridge$post((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent, true);
        ((WorldBridge_Forge)((Object)spongeEvent.getTargetWorld())).forgeBridge$setRedirectedWorldInfo(null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createAndPostWorldLoadEvent(SpongeToForgeEventData eventData) {
        LoadWorldEvent spongeEvent = (LoadWorldEvent)eventData.getSpongeEvent();
        WorldEvent.Load forgeEvent = (WorldEvent.Load)eventData.getForgeEvent();
        net.minecraft.world.World minecraftWorld = (net.minecraft.world.World)spongeEvent.getTargetWorld();
        if (minecraftWorld.field_73011_w.getDimension() != 0) {
            DerivedWorldInfo info = new DerivedWorldInfo(WorldManager.getWorldByDimensionId(0).get().func_72912_H());
            ((DerivedWorldInfoBridge_Forge)info).forgeBridge$setOverrideLevelName(minecraftWorld.func_72912_H().func_76065_j());
            ((WorldBridge_Forge)((Object)spongeEvent.getTargetWorld())).forgeBridge$setRedirectedWorldInfo((WorldInfo)info);
        }
        ((ChunkProviderServerBridge)minecraftWorld.func_72863_F()).bridge$setForceChunkRequests(true);
        try {
            if (forgeEvent == null) {
                forgeEvent = new WorldEvent.Load(minecraftWorld);
                eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
            }
            forgeEventBus.forgeBridge$post((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent, true);
            boolean bl = true;
            return bl;
        }
        finally {
            ((ChunkProviderServerBridge)minecraftWorld.func_72863_F()).bridge$setForceChunkRequests(false);
            ((WorldBridge_Forge)minecraftWorld).forgeBridge$setRedirectedWorldInfo(null);
        }
    }

    private static boolean createAndPostWorldUnloadEvent(SpongeToForgeEventData eventData) {
        UnloadWorldEvent spongeEvent = (UnloadWorldEvent)eventData.getSpongeEvent();
        WorldEvent.Unload forgeEvent = (WorldEvent.Unload)eventData.getForgeEvent();
        if (forgeEvent == null) {
            forgeEvent = new WorldEvent.Unload((net.minecraft.world.World)spongeEvent.getTargetWorld());
            eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
        }
        forgeEventBus.forgeBridge$post((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent, true);
        return true;
    }

    private static boolean createAndPostChunkLoadEvent(SpongeToForgeEventData eventData) {
        LoadChunkEvent spongeEvent = (LoadChunkEvent)eventData.getSpongeEvent();
        ChunkEvent.Load forgeEvent = (ChunkEvent.Load)eventData.getForgeEvent();
        if (forgeEvent == null) {
            Chunk chunk = (Chunk)spongeEvent.getTargetChunk();
            forgeEvent = new ChunkEvent.Load(chunk);
            eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
        }
        forgeEventBus.forgeBridge$post((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent, true);
        return true;
    }

    private static boolean createAndPostChunkUnloadEvent(SpongeToForgeEventData eventData) {
        UnloadChunkEvent spongeEvent = (UnloadChunkEvent)eventData.getSpongeEvent();
        ChunkEvent.Unload forgeEvent = (ChunkEvent.Unload)eventData.getForgeEvent();
        if (forgeEvent == null) {
            Chunk chunk = (Chunk)spongeEvent.getTargetChunk();
            forgeEvent = new ChunkEvent.Unload(chunk);
            eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
        }
        forgeEventBus.forgeBridge$post((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent, true);
        return true;
    }

    private static boolean createAndPostItemFishedEvent(SpongeToForgeEventData eventData) {
        FishingEvent.Stop spongeEvent = (FishingEvent.Stop)eventData.getSpongeEvent();
        ItemFishedEvent forgeEvent = (ItemFishedEvent)eventData.getForgeEvent();
        List<Transaction<ItemStackSnapshot>> potentialFishies = spongeEvent.getTransactions();
        if (potentialFishies.isEmpty()) {
            return false;
        }
        if (forgeEvent == null) {
            List itemstacks = spongeEvent.getTransactions().stream().filter(Transaction::isValid).map(transaction -> ((ItemStackSnapshot)transaction.getFinal()).createStack()).map(ItemStackUtil::toNative).collect(Collectors.toList());
            if (itemstacks.isEmpty()) {
                return false;
            }
            forgeEvent = new ItemFishedEvent(itemstacks, 0, (EntityFishHook)spongeEvent.getFishHook());
            eventData.setForgeEvent((net.minecraftforge.fml.common.eventhandler.Event)forgeEvent);
        }
        forgeEventBus.forgeBridge$post(eventData);
        return true;
    }

    public static void onPostEnd(SpongeToForgeEventData eventData) {
    }

    private static Tristate getTristateFromResult(Event.Result result) {
        if (result == Event.Result.ALLOW) {
            return Tristate.TRUE;
        }
        if (result == Event.Result.DENY) {
            return Tristate.FALSE;
        }
        return Tristate.UNDEFINED;
    }
}

