/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text.placeholder;

import com.google.common.base.Preconditions;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.placeholder.PlaceholderContext;
import org.spongepowered.api.text.placeholder.PlaceholderParser;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.text.placeholder.SpongePlaceholderParser;

public class SpongePlaceholderParserBuilder
implements PlaceholderParser.Builder {
    @Nullable
    private PluginContainer pluginContainer;
    @Nullable
    private String id;
    @Nullable
    private String name;
    @Nullable
    private Function<PlaceholderContext, Text> parser;

    @Override
    public PlaceholderParser.Builder plugin(Object plugin) {
        this.pluginContainer = SpongeImpl.getPluginContainer(plugin);
        return this;
    }

    @Override
    public PlaceholderParser.Builder id(String id) {
        Preconditions.checkArgument((!id.contains(":") && !id.contains(" ") ? 1 : 0) != 0, (Object)"The ID must not contain a color or space.");
        this.id = id;
        return this;
    }

    @Override
    public PlaceholderParser.Builder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public PlaceholderParser.Builder parser(Function<PlaceholderContext, Text> parser) {
        this.parser = parser;
        return this;
    }

    @Override
    public PlaceholderParser build() throws IllegalStateException {
        Preconditions.checkState((this.pluginContainer != null ? 1 : 0) != 0, (Object)"Plugin must be set");
        Preconditions.checkState((this.id != null ? 1 : 0) != 0, (Object)"ID must be set");
        Preconditions.checkState((this.parser != null ? 1 : 0) != 0, (Object)"Parser must be set");
        String name = this.name == null ? this.id : this.name;
        String pluginId = this.pluginContainer.getId() + ":" + this.id;
        return new SpongePlaceholderParser(pluginId, name, this.parser);
    }

    @Override
    public PlaceholderParser.Builder from(PlaceholderParser value) {
        Preconditions.checkState((boolean)(value instanceof SpongePlaceholderParser), (Object)"Must be a SpongePlaceholderParser");
        SpongePlaceholderParser spongePlaceholderParser = (SpongePlaceholderParser)value;
        String[] id = spongePlaceholderParser.getId().split(":", 2);
        this.pluginContainer = Sponge.getPluginManager().getPlugin(id[0]).orElseThrow(() -> new IllegalStateException("Cannot get plugin starting with " + id[0]));
        this.id = id[1];
        this.name = spongePlaceholderParser.getName();
        this.parser = spongePlaceholderParser.getParser();
        return this;
    }

    @Override
    public PlaceholderParser.Builder reset() {
        this.pluginContainer = null;
        this.id = null;
        this.name = null;
        this.parser = null;
        return this;
    }
}

