/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.text;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.text.TextFormatting;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.text.format.SpongeTextColor;

public final class TextColorRegistryModule
implements CatalogRegistryModule<TextColor> {
    @RegisterCatalog(value=TextColors.class)
    public static final Map<String, TextColor> textColorMappings = Maps.newHashMap();
    public static final Map<TextFormatting, SpongeTextColor> enumChatColor = Maps.newEnumMap(TextFormatting.class);

    @Override
    public Optional<TextColor> getById(String id) {
        return Optional.ofNullable(textColorMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<TextColor> getAll() {
        return ImmutableList.copyOf(textColorMappings.values());
    }

    @Override
    public void registerDefaults() {
        TextColorRegistryModule.addTextColor(TextFormatting.BLACK, Color.BLACK);
        TextColorRegistryModule.addTextColor(TextFormatting.DARK_BLUE, Color.ofRgb(170));
        TextColorRegistryModule.addTextColor(TextFormatting.DARK_GREEN, Color.ofRgb(43520));
        TextColorRegistryModule.addTextColor(TextFormatting.DARK_AQUA, Color.ofRgb(43690));
        TextColorRegistryModule.addTextColor(TextFormatting.DARK_RED, Color.ofRgb(0xAA0000));
        TextColorRegistryModule.addTextColor(TextFormatting.DARK_PURPLE, Color.ofRgb(0xAA00AA));
        TextColorRegistryModule.addTextColor(TextFormatting.GOLD, Color.ofRgb(0xFFAA00));
        TextColorRegistryModule.addTextColor(TextFormatting.GRAY, Color.ofRgb(0xAAAAAA));
        TextColorRegistryModule.addTextColor(TextFormatting.DARK_GRAY, Color.ofRgb(0x555555));
        TextColorRegistryModule.addTextColor(TextFormatting.BLUE, Color.ofRgb(0x5555FF));
        TextColorRegistryModule.addTextColor(TextFormatting.GREEN, Color.ofRgb(0x55FF55));
        TextColorRegistryModule.addTextColor(TextFormatting.AQUA, Color.ofRgb(0x55FFFF));
        TextColorRegistryModule.addTextColor(TextFormatting.RED, Color.ofRgb(0xFF5555));
        TextColorRegistryModule.addTextColor(TextFormatting.LIGHT_PURPLE, Color.ofRgb(0xFF55FF));
        TextColorRegistryModule.addTextColor(TextFormatting.YELLOW, Color.ofRgb(0xFFFF55));
        TextColorRegistryModule.addTextColor(TextFormatting.WHITE, Color.WHITE);
        TextColorRegistryModule.addTextColor(TextFormatting.RESET, Color.WHITE);
        textColorMappings.put("none", TextColors.NONE);
    }

    private static void addTextColor(TextFormatting handle, Color color) {
        SpongeTextColor spongeColor = new SpongeTextColor(handle, color);
        textColorMappings.put(handle.name().toLowerCase(Locale.ENGLISH), spongeColor);
        enumChatColor.put(handle, spongeColor);
    }
}

