/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.filter;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import org.spongepowered.common.event.filter.EventFilter;
import org.spongepowered.common.event.filter.FilterGenerator;
import org.spongepowered.common.event.gen.DefineableClassLoader;

public class FilterFactory {
    private final AtomicInteger id = new AtomicInteger();
    private final DefineableClassLoader classLoader;
    private final LoadingCache<Method, Class<? extends EventFilter>> cache = CacheBuilder.newBuilder().concurrencyLevel(1).weakValues().build((CacheLoader)new CacheLoader<Method, Class<? extends EventFilter>>(){

        public Class<? extends EventFilter> load(Method method) throws Exception {
            return FilterFactory.this.createClass(method);
        }
    });
    private final String targetPackage;

    public FilterFactory(String targetPackage, DefineableClassLoader classLoader) {
        Preconditions.checkNotNull((Object)targetPackage, (Object)"targetPackage");
        Preconditions.checkArgument((!targetPackage.isEmpty() ? 1 : 0) != 0, (Object)"targetPackage cannot be empty");
        this.targetPackage = targetPackage + '.';
        this.classLoader = (DefineableClassLoader)Preconditions.checkNotNull((Object)classLoader, (Object)"classLoader");
    }

    public Class<? extends EventFilter> createFilter(Method method) throws Exception {
        return (Class)this.cache.get((Object)method);
    }

    Class<? extends EventFilter> createClass(Method method) {
        Class<?> handle = method.getDeclaringClass();
        Class<?> eventClass = method.getParameterTypes()[0];
        String name = this.targetPackage + eventClass.getSimpleName() + "Filter_" + handle.getSimpleName() + '_' + method.getName() + this.id.incrementAndGet();
        byte[] cls = FilterGenerator.getInstance().generateClass(name, method);
        return this.classLoader.defineClass(name, cls);
    }
}

