/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import com.google.common.base.CaseFormat;
import com.google.common.reflect.TypeToken;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.common.SpongeImpl;

public class ListenerChecker {
    private static final boolean ALL_TRUE = Boolean.parseBoolean(System.getProperty("sponge.shouldFireAll", "").toLowerCase());
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("sponge.debugShouldFire", "").toLowerCase());
    private final Class<?> clazz;
    private Map<String, FieldData> fields = new HashMap<String, FieldData>();
    private Map<Class<?>, FieldData> fieldClassMap = new IdentityHashMap();

    private static String getName(Class<?> clazz) {
        String name = clazz.getName().substring(clazz.getName().lastIndexOf(".") + 1).replace("$", "");
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, name);
    }

    public <T> void registerListenerFor(Class<T> eventClass) {
        this.updateFields(eventClass, true);
    }

    public <T> void unregisterListenerFor(Class<T> eventClass) {
        this.updateFields(eventClass, false);
    }

    public ListenerChecker(Class<?> clazz) {
        this.clazz = clazz;
        for (Field field : this.clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) && Modifier.isPublic(field.getModifiers())) {
                FieldData data = new FieldData(field);
                this.fieldClassMap.put(this.getClassForField(field), data);
                this.fields.put(field.getName(), data);
                if (!ALL_TRUE) continue;
                if (DEBUG) {
                    System.err.println(String.format("Forcing field %s to true!", field.getName()));
                }
                try {
                    field.set(null, true);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                continue;
            }
            throw new IllegalStateException(String.format("ShouldFire filed %s must be public and static!", field));
        }
    }

    private Class<?> getClassForField(Field field) {
        String name = field.getName();
        for (Method eventMethod : SpongeEventFactory.class.getMethods()) {
            for (TypeToken eventType : TypeToken.of(eventMethod.getReturnType()).getTypes()) {
                String eventMethodName = ListenerChecker.getName(eventType.getRawType());
                if (!name.equals(eventMethodName)) continue;
                return eventType.getRawType();
            }
        }
        throw new IllegalStateException(String.format("ShouldFire field %s does not correspond to any SpongeAPI event! Check that the field is written in UPPER_CASE_UNDERSCORE format.", field));
    }

    public <T> void updateFields(Class<? super T> eventClass, boolean registering) {
        if (ALL_TRUE) {
            return;
        }
        Set superTypes = (Set)TypeToken.of(eventClass).getTypes().rawTypes().stream().filter(c -> c != eventClass).collect(Collectors.toCollection(ReferenceOpenHashSet::new));
        for (Map.Entry<Class<?>, FieldData> entry : this.fieldClassMap.entrySet()) {
            if (!eventClass.isAssignableFrom(entry.getKey()) && !superTypes.contains(entry.getKey())) continue;
            entry.getValue().update(registering);
        }
    }

    private static class FieldData {
        Field field;
        int listenerCount = 0;

        FieldData(Field field) {
            this.field = field;
        }

        void update(boolean increment) {
            boolean val;
            this.listenerCount = increment ? ++this.listenerCount : --this.listenerCount;
            if (this.listenerCount < 0) {
                SpongeImpl.getLogger().error(String.format("Decremented listener count to %s for field %s", this.listenerCount, this.field), (Throwable)new Exception("Dummy exception"));
            }
            boolean bl = val = this.listenerCount > 0;
            if (DEBUG) {
                System.err.println(String.format("Updating field %s with value %s", this.field, val));
            }
            try {
                this.field.set(null, val);
            }
            catch (IllegalAccessException e) {
                SpongeImpl.getLogger().error(String.format("Error setting field %s to %s", this.field, val), (Throwable)e);
            }
        }
    }
}

