/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value.immutable;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.function.Function;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableBoundedValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public class ImmutableSpongeBoundedValue<E>
extends ImmutableSpongeValue<E>
implements ImmutableBoundedValue<E> {
    private final Comparator<E> comparator;
    private final E minimum;
    private final E maximum;

    public static <T> ImmutableBoundedValue<T> cachedOf(Key<? extends BaseValue<T>> key, T defaultValue, T actualValue, Comparator<T> comparator, T minimum, T maximum) {
        return (ImmutableBoundedValue)ImmutableDataCachingUtil.getValue(ImmutableSpongeBoundedValue.class, key, defaultValue, actualValue, comparator, minimum, maximum);
    }

    public ImmutableSpongeBoundedValue(Key<? extends BaseValue<E>> key, E defaultValue, Comparator<E> comparator, E minimum, E maximum) {
        super(key, defaultValue);
        this.comparator = (Comparator)Preconditions.checkNotNull(comparator);
        this.minimum = Preconditions.checkNotNull(minimum);
        this.maximum = Preconditions.checkNotNull(maximum);
        Preconditions.checkState((comparator.compare(maximum, minimum) >= 0 ? 1 : 0) != 0);
    }

    public ImmutableSpongeBoundedValue(Key<? extends BaseValue<E>> key, E defaultValue, E actualValue, Comparator<E> comparator, E minimum, E maximum) {
        super(key, defaultValue, actualValue);
        this.comparator = (Comparator)Preconditions.checkNotNull(comparator);
        this.minimum = Preconditions.checkNotNull(minimum);
        this.maximum = Preconditions.checkNotNull(maximum);
        Preconditions.checkState((comparator.compare(maximum, minimum) >= 0 ? 1 : 0) != 0);
    }

    @Override
    public ImmutableBoundedValue<E> with(E value) {
        if (this.comparator.compare(value, this.minimum) >= 0 && this.comparator.compare(value, this.maximum) <= 0) {
            return new ImmutableSpongeBoundedValue(this.getKey(), this.getDefault(), value, this.getComparator(), this.getMinValue(), this.getMaxValue());
        }
        return new ImmutableSpongeBoundedValue(this.getKey(), this.getDefault(), this.getComparator(), this.getMinValue(), this.getMaxValue());
    }

    @Override
    public ImmutableBoundedValue<E> transform(Function<E, E> function) {
        return this.with(Preconditions.checkNotNull(((Function)Preconditions.checkNotNull(function)).apply(this.get())));
    }

    @Override
    public MutableBoundedValue<E> asMutable() {
        return SpongeValueFactory.boundedBuilder(this.getKey()).defaultValue(this.getDefault()).minimum(this.getMinValue()).maximum(this.getMaxValue()).actualValue(this.get()).comparator(this.getComparator()).build();
    }

    @Override
    public E getMinValue() {
        return this.minimum;
    }

    @Override
    public E getMaxValue() {
        return this.maximum;
    }

    @Override
    public Comparator<E> getComparator() {
        return this.comparator;
    }
}

