/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.explosive.FusedExplosive;
import org.spongepowered.common.bridge.explosives.FusedExplosiveBridge;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class TicksRemainingValueProcessor
extends AbstractSpongeValueProcessor<FusedExplosive, Integer, Value<Integer>> {
    public TicksRemainingValueProcessor() {
        super(FusedExplosive.class, Keys.TICKS_REMAINING);
    }

    @Override
    protected Value<Integer> constructValue(Integer actualValue) {
        return new SpongeValue<Integer>(Keys.TICKS_REMAINING, actualValue);
    }

    @Override
    protected boolean set(FusedExplosive container, Integer value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)"ticks remaining cannot be less than zero");
        if (container.isPrimed()) {
            ((FusedExplosiveBridge)((Object)container)).bridge$setFuseTicksRemaining(value);
            return true;
        }
        return false;
    }

    @Override
    protected Optional<Integer> getVal(FusedExplosive container) {
        return Optional.of(((FusedExplosiveBridge)((Object)container)).bridge$getFuseTicksRemaining());
    }

    @Override
    protected ImmutableValue<Integer> constructImmutableValue(Integer value) {
        return new ImmutableSpongeValue<Integer>(Keys.TICKS_REMAINING, value);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

