/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.common;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.ValueProcessor;
import org.spongepowered.common.data.processor.common.AbstractSingleDataProcessor;
import org.spongepowered.common.data.util.DataUtil;

public abstract class AbstractSingleDataSingleTargetProcessor<Holder, T, V extends BaseValue<T>, M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>>
extends AbstractSingleDataProcessor<T, V, M, I>
implements ValueProcessor<T, V> {
    protected final Class<Holder> holderClass;

    protected AbstractSingleDataSingleTargetProcessor(Key<V> key, Class<Holder> holderClass) {
        super(key);
        this.holderClass = (Class)Preconditions.checkNotNull(holderClass);
    }

    protected boolean supports(Holder dataHolder) {
        return true;
    }

    protected abstract boolean set(Holder var1, T var2);

    protected abstract Optional<T> getVal(Holder var1);

    protected abstract ImmutableValue<T> constructImmutableValue(T var1);

    @Override
    public boolean supports(DataHolder dataHolder) {
        return this.holderClass.isInstance(dataHolder) && this.supports((Holder)dataHolder);
    }

    @Override
    public boolean supports(EntityType entityType) {
        return this.holderClass.isAssignableFrom(entityType.getEntityClass());
    }

    @Override
    public DataTransactionResult set(DataHolder dataHolder, M manipulator, MergeFunction function) {
        if (this.supports(dataHolder)) {
            DataTransactionResult.Builder builder = DataTransactionResult.builder();
            Optional<M> old = this.from(dataHolder);
            DataManipulator merged = (DataManipulator)((MergeFunction)Preconditions.checkNotNull((Object)function)).merge(old.orElse(null), manipulator);
            Object newValue = merged.get(this.key).get();
            ImmutableValue immutableValue = ((Value)merged.getValue(this.key).get()).asImmutable();
            try {
                if (this.set(dataHolder, newValue)) {
                    if (old.isPresent()) {
                        builder.replace(((DataManipulator)old.get()).getValues());
                    }
                    return builder.result(DataTransactionResult.Type.SUCCESS).success(immutableValue).build();
                }
                return builder.result(DataTransactionResult.Type.FAILURE).reject(immutableValue).build();
            }
            catch (Exception e) {
                SpongeImpl.getLogger().debug("An exception occurred when setting data: ", (Throwable)e);
                return builder.result(DataTransactionResult.Type.ERROR).reject(immutableValue).build();
            }
        }
        return DataTransactionResult.failResult(manipulator.getValues());
    }

    @Override
    public Optional<M> fill(DataHolder dataHolder, M manipulator, MergeFunction overlap) {
        if (!this.supports(dataHolder)) {
            return Optional.empty();
        }
        DataManipulator merged = (DataManipulator)((MergeFunction)Preconditions.checkNotNull((Object)overlap)).merge(manipulator.copy(), this.from(dataHolder).orElse(null));
        return Optional.of(manipulator.set(this.key, merged.get(this.key).get()));
    }

    @Override
    public Optional<M> fill(DataContainer container, M m) {
        Object data = DataUtil.getData(container, this.key);
        m.set(this.key, data);
        return Optional.of(m);
    }

    @Override
    public Optional<I> with(Key<? extends BaseValue<?>> key, Object value, I immutable) {
        if (immutable.supports(key)) {
            return Optional.of(immutable.asMutable().set(this.key, (Object)value).asImmutable());
        }
        return Optional.empty();
    }

    @Override
    public Optional<M> from(DataHolder dataHolder) {
        if (!this.supports(dataHolder)) {
            return Optional.empty();
        }
        Optional<T> optional = this.getVal(dataHolder);
        if (optional.isPresent()) {
            return Optional.of(this.createManipulator().set(this.key, optional.get()));
        }
        return Optional.empty();
    }

    @Override
    public final Key<V> getKey() {
        return this.key;
    }

    protected abstract V constructValue(T var1);

    @Override
    public final boolean supports(ValueContainer<?> container) {
        return this.holderClass.isInstance(container) && this.supports((Holder)container);
    }

    @Override
    public final Optional<T> getValueFromContainer(ValueContainer<?> container) {
        if (!this.supports(container)) {
            return Optional.empty();
        }
        return this.getVal(container);
    }

    @Override
    public Optional<V> getApiValueFromContainer(ValueContainer<?> container) {
        Optional<T> optionalValue = this.getValueFromContainer(container);
        if (optionalValue.isPresent()) {
            return Optional.of(this.constructValue(optionalValue.get()));
        }
        return Optional.empty();
    }

    @Override
    public DataTransactionResult offerToStore(ValueContainer<?> container, T value) {
        ImmutableValue<T> newValue = this.constructImmutableValue(value);
        if (this.supports(container)) {
            DataTransactionResult.Builder builder = DataTransactionResult.builder();
            Optional<T> oldVal = this.getVal(container);
            try {
                if (this.set(container, value)) {
                    if (oldVal.isPresent()) {
                        builder.replace(this.constructImmutableValue(oldVal.get()));
                    }
                    return builder.result(DataTransactionResult.Type.SUCCESS).success(newValue).build();
                }
                return builder.result(DataTransactionResult.Type.FAILURE).reject(newValue).build();
            }
            catch (Exception e) {
                SpongeImpl.getLogger().debug("An exception occurred when setting data: ", (Throwable)e);
                return builder.result(DataTransactionResult.Type.ERROR).reject(newValue).build();
            }
        }
        return DataTransactionResult.failResult(newValue);
    }

    @Override
    public final DataTransactionResult remove(DataHolder dataHolder) {
        return this.removeFrom(dataHolder);
    }
}

