/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableCommandData;
import org.spongepowered.api.data.manipulator.mutable.CommandData;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.api.data.value.mutable.OptionalValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.data.manipulator.immutable.ImmutableSpongeCommandData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.data.value.mutable.SpongeOptionalValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SpongeCommandData
extends AbstractData<CommandData, ImmutableCommandData>
implements CommandData {
    private String command = "";
    private int success;
    private boolean tracks;
    @Nullable
    private Text lastOutput;

    public SpongeCommandData() {
        super(CommandData.class);
        this.registerGettersAndSetters();
    }

    @Override
    public Value<String> storedCommand() {
        return new SpongeValue<String>(Keys.COMMAND, this.getStoredCommand());
    }

    public MutableBoundedValue<Integer> successCount() {
        return SpongeValueFactory.boundedBuilder(Keys.SUCCESS_COUNT).actualValue(this.success).defaultValue(0).minimum(0).maximum(Integer.MAX_VALUE).build();
    }

    @Override
    public Value<Boolean> doesTrackOutput() {
        return new SpongeValue<Boolean>(Keys.TRACKS_OUTPUT, this.tracks);
    }

    @Override
    public OptionalValue<Text> lastOutput() {
        return new SpongeOptionalValue<Text>(Keys.LAST_COMMAND_OUTPUT, this.getLastOutput());
    }

    @Override
    public CommandData copy() {
        return new SpongeCommandData().setStoredCommand(this.getStoredCommand()).setSuccessCount(this.getSuccessCount()).shouldTrackOutput(this.tracks).setLastOutput(this.getLastOutput().orElse(Text.of()));
    }

    @Override
    public ImmutableCommandData asImmutable() {
        return new ImmutableSpongeCommandData(this.command, this.success, this.tracks, this.lastOutput);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.COMMAND.getQuery(), (Object)this.command).set(Keys.SUCCESS_COUNT.getQuery(), (Object)this.success).set(Keys.TRACKS_OUTPUT.getQuery(), (Object)this.tracks).set(Keys.LAST_COMMAND_OUTPUT.getQuery(), (Object)(this.lastOutput == null ? "" : this.lastOutput.toString()));
    }

    public String getStoredCommand() {
        return this.command;
    }

    public SpongeCommandData setStoredCommand(String command) {
        this.command = (String)Preconditions.checkNotNull((Object)command);
        return this;
    }

    public int getSuccessCount() {
        return this.success;
    }

    public SpongeCommandData setSuccessCount(int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0);
        this.success = count;
        return this;
    }

    public boolean tracksOutput() {
        return this.tracks;
    }

    public SpongeCommandData shouldTrackOutput(boolean track) {
        this.tracks = track;
        return this;
    }

    public Optional<Text> getLastOutput() {
        return Optional.ofNullable(this.lastOutput);
    }

    public SpongeCommandData setLastOutput(@Nullable Text message) {
        if (message == null) {
            this.lastOutput = null;
            return this;
        }
        this.lastOutput = ((Text)Preconditions.checkNotNull((Object)message, (Object)"message")).isEmpty() ? null : message;
        return this;
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.COMMAND, this::getStoredCommand);
        this.registerFieldSetter(Keys.COMMAND, this::setStoredCommand);
        this.registerKeyValue(Keys.COMMAND, this::storedCommand);
        this.registerFieldGetter(Keys.SUCCESS_COUNT, this::getSuccessCount);
        this.registerFieldSetter(Keys.SUCCESS_COUNT, this::setSuccessCount);
        this.registerKeyValue(Keys.SUCCESS_COUNT, () -> this.successCount());
        this.registerFieldGetter(Keys.TRACKS_OUTPUT, this::tracksOutput);
        this.registerFieldSetter(Keys.TRACKS_OUTPUT, this::shouldTrackOutput);
        this.registerKeyValue(Keys.TRACKS_OUTPUT, this::doesTrackOutput);
        this.registerFieldGetter(Keys.LAST_COMMAND_OUTPUT, this::getLastOutput);
        this.registerFieldSetter(Keys.LAST_COMMAND_OUTPUT, optional -> this.setLastOutput(optional.orElse(Text.of())));
        this.registerKeyValue(Keys.LAST_COMMAND_OUTPUT, this::lastOutput);
    }
}

