/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.manipulator;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Optional;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.ImmutableDataHolder;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulatorBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.common.data.util.DataFunction;
import org.spongepowered.common.data.util.DataProcessorDelegate;

public final class SpongeImmutableDataManipulatorBuilder<T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>>
implements ImmutableDataManipulatorBuilder<I, T> {
    private final DataProcessorDelegate<T, I> delegate;
    private final Class<T> manipulatorClass;
    private final Constructor<T> constructor;
    private final DataFunction<DataContainer, T, Optional<T>> buildFunction;

    public SpongeImmutableDataManipulatorBuilder(DataProcessorDelegate<T, I> delegate, Class<T> manipulatorClass, DataFunction<DataContainer, T, Optional<T>> buildFunction) {
        this.delegate = (DataProcessorDelegate)Preconditions.checkNotNull(delegate);
        Preconditions.checkNotNull(manipulatorClass);
        Preconditions.checkArgument((!Modifier.isAbstract(manipulatorClass.getModifiers()) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Modifier.isInterface(manipulatorClass.getModifiers()) ? 1 : 0) != 0);
        this.manipulatorClass = manipulatorClass;
        try {
            this.constructor = manipulatorClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No no-args constructor found for class: " + manipulatorClass.getCanonicalName(), e);
        }
        this.buildFunction = (DataFunction)Preconditions.checkNotNull(buildFunction);
    }

    @Override
    public Optional<I> createFrom(DataHolder dataHolder) {
        Optional<T> optional = this.delegate.createFrom(dataHolder);
        if (optional.isPresent()) {
            return Optional.of(((DataManipulator)optional.get()).asImmutable());
        }
        return Optional.empty();
    }

    @Override
    public Optional<I> createFrom(ImmutableDataHolder<?> dataHolder) {
        return null;
    }

    @Override
    public ImmutableDataManipulatorBuilder<I, T> reset() {
        return this;
    }

    @Override
    public I createImmutable() {
        try {
            return ((DataManipulator)this.constructor.newInstance(new Object[0])).asImmutable();
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("No no-args constructor found for class: " + this.manipulatorClass.getCanonicalName(), e);
        }
    }

    private T create() {
        try {
            return (T)((DataManipulator)this.constructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("No no-args constructor found for class: " + this.manipulatorClass.getCanonicalName(), e);
        }
    }

    @Override
    public Optional<I> build(DataView container) throws InvalidDataException {
        DataContainer usedContainer = container instanceof DataContainer ? (DataContainer)container : container.copy();
        Optional<T> optional = this.buildFunction.apply(usedContainer, this.create());
        return optional.isPresent() ? Optional.of(((DataManipulator)optional.get()).asImmutable()) : Optional.empty();
    }
}

