/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.gen.populator;

import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.manipulator.mutable.MobSpawnerData;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.util.weighted.LootTable;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.api.world.gen.Populator;

public interface Dungeon
extends Populator {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public VariableAmount getAttemptsPerChunk();

    public void setAttemptsPerChunk(VariableAmount var1);

    default public void setAttemptsPerChunk(int attempts) {
        this.setAttemptsPerChunk(VariableAmount.fixed(attempts));
    }

    public Optional<MobSpawnerData> getMobSpawnerData();

    public void setMobSpawnerData(MobSpawnerData var1);

    public Optional<WeightedTable<EntityArchetype>> getChoices();

    public void setChoices(WeightedTable<EntityArchetype> var1);

    public LootTable<ItemStackSnapshot> getPossibleContents();

    public static interface Builder
    extends ResettableBuilder<Dungeon, Builder> {
        public Builder attempts(VariableAmount var1);

        default public Builder attempts(int attempts) {
            return this.attempts(VariableAmount.fixed(attempts));
        }

        public Builder mobSpawnerData(MobSpawnerData var1);

        public Builder choices(@Nullable WeightedTable<EntityArchetype> var1);

        public Builder possibleItems(LootTable<ItemStackSnapshot> var1);

        public Dungeon build() throws IllegalStateException;
    }
}

