/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.recipe.smelting;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;

public final class SmeltingResult {
    private final ItemStackSnapshot result;
    private final double experience;

    public SmeltingResult(ItemStackSnapshot result, double experience) {
        Preconditions.checkNotNull((Object)result, (Object)"result");
        Preconditions.checkArgument((result != ItemStackSnapshot.NONE ? 1 : 0) != 0, (Object)"The result must not be ItemStackSnapshot.NONE.");
        Preconditions.checkArgument((experience >= 0.0 ? 1 : 0) != 0, (Object)"The experience must be non-negative.");
        this.result = result;
        this.experience = experience;
    }

    public ItemStackSnapshot getResult() {
        return this.result;
    }

    public double getExperience() {
        return this.experience;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SmeltingResult)) {
            return false;
        }
        SmeltingResult that = (SmeltingResult)o;
        return Double.compare(that.experience, this.experience) == 0 && Objects.equals(this.result, that.result);
    }

    public int hashCode() {
        return Objects.hash(this.result, this.experience);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("result", (Object)this.result).add("experience", this.experience).toString();
    }
}

