/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.property;

import com.google.common.base.Objects;
import javax.annotation.Nullable;
import org.spongepowered.api.data.Property;

public abstract class AbstractProperty<K, V>
implements Property<K, V> {
    protected final Property.Operator operator;
    private final K key;
    @Nullable
    protected V value;

    protected AbstractProperty() {
        this(null);
    }

    protected AbstractProperty(@Nullable V value) {
        this(value, null);
    }

    protected AbstractProperty(@Nullable V value, @Nullable Property.Operator op) {
        this(null, value, op);
    }

    protected AbstractProperty(@Nullable K key, @Nullable V value) {
        this(key, value, null);
    }

    protected AbstractProperty(@Nullable K key, @Nullable V value, @Nullable Property.Operator op) {
        this.key = key != null ? key : this.getDefaultKey(value);
        this.value = value;
        this.operator = op != null ? op : this.getDefaultOperator(this.key, value);
    }

    protected K getDefaultKey(@Nullable V value) {
        return (K)this.getClass().getSimpleName();
    }

    protected Property.Operator getDefaultOperator(K key, @Nullable V value) {
        return Property.Operator.defaultOperator();
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public Property.Operator getOperator() {
        return this.operator;
    }

    @Override
    public boolean matches(@Nullable Property<?, ?> other) {
        return this.getOperator().compare(this, other);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractProperty)) {
            return false;
        }
        AbstractProperty other = (AbstractProperty)obj;
        return Objects.equal(other.getKey(), this.getKey()) && Objects.equal(other.getValue(), this.getValue());
    }

    public int hashCode() {
        return this.hashCodeOf(this.getKey()) ^ this.hashCodeOf(this.getValue()) * 37;
    }

    public String toString() {
        return this.key + "(" + this.value + ")";
    }

    protected int hashCodeOf(@Nullable Object value) {
        return value != null ? value.hashCode() : 0;
    }
}

